// Base URL for API calls - replace with your actual domain
const BASE_URL = 'https://your-hospital-domain.com/api/';

// Helper function to make API requests
async function apiRequest(endpoint, options = {}) {
    const url = BASE_URL + endpoint;
    const defaultOptions = {
        headers: {
            'Content-Type': 'application/json'
        }
    };
    
    const config = {
        ...defaultOptions,
        ...options,
        body: options.body ? JSON.stringify(options.body) : undefined
    };
    
    try {
        const response = await fetch(url, config);
        const data = await response.json();
        
        if (!response.ok) {
            throw new Error(data.error || 'API request failed');
        }
        
        return data;
    } catch (error) {
        console.error('API Error:', error);
        throw error;
    }
}